﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using TravelDataLib;

namespace TravelManagerWeb
{
  public partial class NewRequest : System.Web.UI.Page
  {
    protected void Page_Load(object sender, EventArgs e)
    {
      if (!IsPostBack)
      {
        // Inicjowanie numeru rezerwacji.
        TextBoxResId.Text = Guid.NewGuid().ToString();
      }
    }

    protected void ButtonRequest_Click(object sender, EventArgs e)
    {
        // Do zrobienia: dodać sprawdzanie poprawności formularza i obiektów.

        // Tworzenie obiektu zgłoszenia podróży przekazywanego do procesu.
      TravelRequestMsg tRequest = new TravelRequestMsg()
      {
        CreationDate = DateTime.Now,
        Id = Guid.NewGuid().ToString(),
        Justification = TextBoxJust.Text,
        Name = TextBoxName.Text,
        RequesterId = TextBoxrequester.Text, 
        TravelEstimate = double.Parse(TextBoxCost.Text),
        VendorReservationId = TextBoxResId.Text,
        ApprovalManagerId = "Nieznany",
        IsApproved = false,
        WorkflowInstanceId = "TBD"
      };

      // Tworzenie obiektu usługi procesu.
      TravelRequestSvc.RequestTravelClient client =
        new TravelRequestSvc.RequestTravelClient();

      // Rozpoczynanie procesu (przekazanie zgłoszenia).
      client.ProcessTravelRequest(tRequest);
      client.Close();

      // Powrót do strony głównej.
      PanelRequest.Visible = false;
      LabelResult.Text = "Wysłano zgłoszenie podróży!";
      PanelResult.Visible = true;

    }
  }
}